var im_webbridge ;
var im_platform ;
//------------封装类-------------
function IMDevice() {

 
    var _ = this;
	_.channel = null ; //pc ;
	_.EMPTYFN = function(){};
	_.platform = 'web' ;  // web/pc/mobile/
	_.os = '';
	_.loginInfo = {
		method: "",                 // 调用方法
		server: "116.62.129.71",    // im消息服务器
		port: "5771",               // im消息服务器端口
		domain: "default",          // 公司ID 默认default
		loginname: "test1",         // 登录帐号
		validType: 0,               // 验证类型  0 明文密码 1 MD5密码 -2 令牌验证
		password: "123456",         // 登录密码
		receiver: "",               // 接收者
		receiver_type: "",          // 接收类型
	};

    /*内部变量*/
    _._socketStatus = -1;
    _._timer = null;
    _._socket = undefined;
	_.isInstallClient = -1;
	_.onCheckInstallFail = function(msg){
		alert("请选安装客户端");
	}
	
    /*
    检测是否安装客户端
    */
    _.checkInstall = function() {
		debugger;
        _._socketStatus = -1;
        try {
            var b = new ActiveXObject("QDSTARTCHECK.QdStartCheckCtrl.1");
            console.log(b);
            if (b != null) {
                checkInstalledCallBack(1,"");
                return;
            }
        } catch (d) {}

        var host = "ws://localhost:5566/";
        try {
            _._socket = new WebSocket(host);
            _._timer = setTimeout(function() {
                _.checkInstallCallback(0, "socket timout");
            }, 1500);
            _._socket.onopen = function() {
                _._socket.send("1" + "im");
                _.checkInstallEnd(1, "socket open");
            }
            _._socket.onmessage = function (event) {
                console.log("socket onmessage");
                console.log(event.data);
            }; 
            _._socket.onclose = function() {
                _.checkInstallEnd(0, "socket close");
            }
            _._socket.onerror = function() {
                _.checkInstallEnd(0, "socket error");
            }


        } catch (exception) {
            _.checkInstallEnd(0, "socket fail");
        }
    }

    _.checkInstallEnd = function(status, msg) {
        if (_._socketStatus == -1) {
            _.checkInstallCallback(status, msg);
        }
        clearTimeout(_._timer);
        _._socketStatus = status;
    }

    _.checkInstallCallback = function(status, msg) {
		msg = msg || '';
		//同时激活timeOut与socket close
		if ((_.isInstallClient == -1) && (status == 0)){
			_.onCheckInstallFail(msg);
		}

		_.isInstallClient = status ;

    }
	
	_.imWork = function(loginInfo) {
		debugger;
		// 调用客户端是否安装
		if (_.isInstallClient) {
			var params = [];
			
			for(var key in loginInfo){
				if (loginInfo[key] != '') {
					params[params.length] = key + '=' + loginInfo[key];
				}
			}
			params = params.join('&');
			// 1必须携带，服务端解析指令
			//_._socket.send('1' + params);
			
			// 2 协议启动
			var url = "workpro://" + loginInfo.method + "/?startup=0" + params;
			console.log(url);
			location.href = url;
		} else {
			//跳转到下载页面
			_.onCheckInstallFail();
		}
	}

	_.imLogin = function() {
		_.loginInfo.method = "login";
		_.loginInfo.receiver = "";
		_.loginInfo.receiver_type = "";
		_.imWork(_.loginInfo);
	}

	_.imSendMsg = function(receiver) {
		_.loginInfo.method = "sendmsg";
		_.loginInfo.receiver = receiver + "@" + _.loginInfo.domain;
		_.loginInfo.receiver_type = 1;
		_.imWork(_.loginInfo);
	}
	
	_.init = function(){
		var useragent = window.navigator.userAgent ;

		if (useragent.indexOf("imwork:android")>-1){
			_.platform = 'mobile';
			_.os = 'android' ;
		}else if (useragent.indexOf("imwork:ios")>-1){
			_.platform = 'mobile';
			_.os = 'ios' ;
		}else if (useragent.indexOf("imwork:pc")>-1){
			_.platform = 'pc';
		}
		im_platform = _.platform; 
		switch(_.platform){
			case 'pc':
				loadJS('qrc:///qtwebchannel/qwebchannel.js',function(){
					new QWebChannel(qt.webChannelTransport, function(channel) {
						_.channel = channel ;
					});
				});
				break;
			case 'mobile':
				setupWebViewJavascriptBridge(function(bridge) {
					im_webbridge = bridge;
				})
				break;
		}
	}
	
	_.getChannel = function(){
		if (_.channel == null){
			alert("不是PC客户端，不能运行此函数");
			return false ;
		}
		return _.channel ;
	}
	
	_.getPlatform  = function(){
		
		return _.platform;
	}
	
    _.callClientFun = function(fun,params,callback) {
		//alert("callClientFun");
    	var data = { 
    		"fun":fun, 
    		"params":params == undefined?{}:params, 
    		"callback":callback == undefined?"":callback
    	};
        var param = JSON.stringify(data);
        if (_.os == 'android') {
            IMClient.function(param);
        } else if (_.os == 'ios') {
            try{
                 im_lisnerid = setInterval(function(){
					 lisner(param);
				 }, 100);
             }catch(error){
                clearInterval(im_lisnerid);
             }
           
        }else{
			var res = {status:0,err_code:"platform_not_supper",err_msg:"此平台不支持:" + fun};
        	eval(callback + "(res)");
        }
    }
	
	_.exec = function(funName,options,defaultOptions){

		if (options == undefined){
			options = {};
		}
		
		//缺省值合并
		if (defaultOptions == undefined){
			defaultOptions = {};
		}
		for( var i in options){
			defaultOptions[i] = options[i];
		}
		options = defaultOptions ;
		im_callback_success = _.EMPTYFN;
		im_callback_fail = function(res){
			alert(res.err_msg);
		}
		
		if (options.success){
			im_callback_success = options.success ;
			delete options.success;
		}
		_.callClientFun(funName,options,"im_callback");
	} 
	
	_.notify = {
		alert:function(options){
			var defaultOptions = {
				title:"提示",
				message:"你好"
			}
			_.exec("alert",options,defaultOptions);
		},
		confirm:function(options){
			var defaultOptions = {
				title:"提示",
				message:"你好"
			}
			_.exec("confirm",options);
		},
		prompt:function(options){
			var defaultOptions = {
				message:"提示",
				defaultValue:""
			}
			_.exec("prompt",options);
		},
		vibrate:function(options){
			_.exec("vibrate",options);
		},
		toast:function(options){
			var defaultOptions = {
				message:"你好",
				duration:5
			}
			_.exec("toast",options,defaultOptions);
		},
		actionSheet:function(options){
			var defaultOptions = {
				message:"选择项目",
				cancelButtonText:"取消"
			}
			_.exec("actionSheet",options,defaultOptions);
		},
		multiSelect:function(options){
			var defaultOptions = {
				options:[],
				selectOptions:[]
			}
			_.exec("multiSelect",options,defaultOptions);
		},
		showLoading:function(options){
			var defaultOptions = {
				message:"正在加载中..."
			}
			_.exec("showLoading",options,defaultOptions);
		},
		hideLoading:function(options){
			_.exec("hideLoading",options);
		}
	}
	_.map = {
		locate:function(options){
			_.exec("getPosition",options);
		},
		view:function(options){
			_.exec("setPosition",options);
		}
	}
	
	
	_.webview = {
		open:function(options){
			if (typeof(options) == 'string'){
				options = {url:options};
			}
			var defaultOptions = {
				hidden:"1",//导航条是否显示 导航条 0限藏 1显示
				type:"0"//打开类型 默认为0 0/1 内置/系统
			}
			
			if (_.platform == 'web'){
				window.open(options.url);
			}else{
				_.exec("openWindow",options,defaultOptions);
			}
			
		},
		set:function(options){
			//老格式的支持 rightMenu {text,icon,event} => [{text,icon,event}]
			if (options.rightMenu && options.rightMenu.event){
				options.rightMenu = [options.rightMenu];
			}
			_.exec("setWindow",options);
		},
		close:function(options){
			_.exec("closeWindow",options);
		},
		openWebFile:function(options){
			_.exec("openWebFile",options);
		}
	}
	_.fm = {
		chooseFile:function(options){
			_.exec("chooseFile",options);
		},

		
		//options {url,size,name,success}
		downloadFile:function(options){
			var url,name;
			if (typeof(options) == "string"){
				url = options; 
			}else{
				url = options.url; 
				name= options.name;
			}
			if (url.length<4){
				return ;
			}

			if (name == undefined){
				name = url.substring(url.lastIndexOf("/")+1);
			}
			
			if (_.platform == 'web'){
					var a = document.createElement("a");
					a.setAttribute("href",url);
					a.setAttribute("download",name);
					a.click();
			}else{
				url = _.fm.getFileFullUrl(url);
				if (_.platform == 'pc'){
					_.channel.objects.signalManager.downloadFile(url,name); 
				}else{
					_.exec("downloadFile",options);
				}
				
			}

			
		},
		
		getFileFullUrl:function(url){
			if (url.indexOf("http") != 0){
				if (url.substring(0,4) != "http"){
					url = location.origin + url ;
				}
			}
			return url ;
		},
		
		previewFile:function(options){
			switch(_.platform){
				case 'pc':
					options.url = _.fm.getFileFullUrl(options.url);
					_.exec("downloadFile",options);
					break;
				case 'mobile':
					options.url = _.fm.getFileFullUrl(options.url);
					_.exec("previewFile",options);
					break;

			}
			
			//web 
			window.open(options.url);
			
		},
		previewImage:function(options){
			options.photos = options.files ; 
			var defaultOptions = {
				index:0
			}
			_.exec("previewPhoto",options);
		}
	}
	
	_.audio = {
		//options {max_duration:60,success:{file:"",duration:40,auto_close:0}}
		startRecord:function(options){
			var defaultOptions = {
				max_duration:60
			}
			_.exec("startAudio",options,defaultOptions);
		},
		//options {url,success}
		play:function(options){
			_.exec("playAudio",options);
		}
	}
	
	_.video = {
		//options {duration_limit:60,success:{thumb_file:"",file:"",duration:40,auto_close:0}}
		startRecord:function(options){
			_.exec("startVideo",options);
		},
		//options {url,success}
		play:function(options){
			_.exec("playVideo",options);
		}
	}

	_.camera = {
		//options {type:"none/video/image",success}
		record:function(options){
			var defaultOptions = {
				type:"none"
			}
			_.exec("recordCamera",options,defaultOptions);
		},
	}
	
	_.contacts = {
		//options {type:"u",limit,data,success}
		choose:function(options){
			var defaultOptions = {
				type:"u",// u:user
				limit:0,
				selected:[] //[{'type':'u','id':'','name':''}]
			}
			_.exec("selectContacts",options,defaultOptions);
		},
		
		//options {limit,selected,removes}
		externalChoose:function(options){
			var defaultOptions = {
				limit:0,
				selected:[],
				removes:[]
			}
			_.exec("selectExternalContacts",options,defaultOptions);
		},
		
		//options {id:""}
		externalEditForm:function(options){
			var defaultOptions = {

			}
			_.exec("editExternalContactForm",options,defaultOptions);
		},
	}
	
	_.app = {
		
		// options {url,query,success}
		open:function(options){
			_.exec("open",options);
		},
		
		//
		open2:function(url,options){
			var query = {} ;
			for(var key in options){
				if (["success","fail"].indexOf(key) == -1){
					query[key] = options[key];
					delete options[key];
				}
			}
			options.url = url;
			options.query = query;
			_.exec("open",options);
		},
		
		conversationList:function(options){
			_.app.open2("conversationList",options);
		},
		
		dialogue:function(options){
			_.app.open2("dialogue",options);
		},
		
		addressList:function(options){
			_.app.open2("addressList",options);
		},
		
		friendSearch:function(options){
			_.app.open2("friendSearch",options);
		},	

		groupInfo:function(options){
			_.app.open2("groupInfo",options);
		},	
		createGroup:function(options){
			_.app.open2("createGroup",options);
		},	
		
		userInfo:function(options){
			_.app.open2("userInfo",options);
		}
	}
	
	_.calendar = {
		//options {success}
		datepicker:function(options){
			_.exec("datepicker",options);
		},
		//options {success}
		timepicker:function(options){
			_.exec("timepicker",options);
		},
		
		//options {}
		datetimepicker:function(options){
			_.exec("datetimepicker",options);
		},
		//options {}
		datetimerangpicker:function(options){
			_.exec("datetimerangpicker",options);
		}
	}
	
	_.utils = {
		//options {success}
		getLoginInfo:function(options){
			_.exec("getLoginInfo",options);
		},
		
		//options {}
		getVersion:function(options){
			_.exec("getVersion",options);
		},
		
		//options {success}
		scan:function(options){
			_.exec("scan",options);
		},
		
		//options {appcode:"应用code",targetId:"应用下属ID 如服务号ID"}
		startLocalApp:function(options){
			_.exec("startLocalApp",options);
		},
		//options {}
		startShareMenu:function(options){
			_.exec("startShareMenu",options);
		},
		
		openUserChat:function(user_id){
			var channel = _.getChannel();
			if (!channel){return;}
			channel.objects.signalManager.change2MessageCenter2(user_id,0,true); 
		},
		
		openGroupChat:function(group_id){
			var channel = _.getChannel();
			if (!channel){return;}
			channel.objects.signalManager.change2MessageCenter2(group_id,1,true); 
		},
	}
	


 
}
//------------/封装类-------------


//------------初始化-------------
var imdevice = new IMDevice();
imdevice.init();

function loadJS(url, success) {
	var domScript = document.createElement('script');
	domScript.src = url;
	success = success || function () {};
	domScript.onload = domScript.onreadystatechange = function () {
		if (!this.readyState || 'loaded' === this.readyState || 'complete' === this.readyState) {
			success();
			this.onload = this.onreadystatechange = null;
			this.parentNode.removeChild(this);
		}
	}
	document.getElementsByTagName('head')[0].appendChild(domScript);
}

/**
 * 监听ios对象是否被创建
 * @param param
 * @returns
 */
function lisner(param) {
    if (im_webbridge != undefined) {
        clearInterval(im_lisnerid);
        im_webbridge.callHandler(
            'IMClient.function',
            param,
            function responseCallback(string) {
                //myAlert(string);
            }
		)
    }
}

/**
 * 浏览器引擎
 * @param {Object} callback
 */
function setupWebViewJavascriptBridge(callback) {
    if (window.WebViewJavascriptBridge) {
        return callback(WebViewJavascriptBridge);
    }
    if (window.WVJBCallbacks) {
        return window.WVJBCallbacks.push(callback);
    }
    window.WVJBCallbacks = [callback];
    var WVJBIframe = document.createElement('iframe');
    WVJBIframe.style.display = 'none';
    //WVJBIframe.src = 'wvjbscheme://__BRIDGE_LOADED__';
	WVJBIframe.src = 'https://__bridge_loaded__';

    document.documentElement.appendChild(WVJBIframe);
    setTimeout(function() { document.documentElement.removeChild(WVJBIframe) }, 0)
}


function im_callback(res){
	//alert("im_callback");
	if (res.status != undefined){
		if (res.status == 1){
			im_callback_success(res.data);
		}else{
			im_callback_fail(res);
		}
		
	}else{
		im_callback_success(res);
	}
}

function im_callback_success(data){

}

function im_callback_fail(res){

}

var i = 0 ;
function selectUser(){
	
	var users = [{type:'u',name:'jinc',id:'jinc'}] ;
	if (i==1){
		 users = [{type:'u',name:'wym',id:'wym'},{type:'u',name:'jinc',id:'jinc'}] ;
	}
	i = 1 ;
	onSelectUser(users);
}



//------------/初始化-------------





